#!/bin/bash

# usbmemlabel.sh
#
# Usage: usbmemlabel.sh <device file> <label file> <log file> <dos letter>
#
# Return Codes:
# 1 - Error reading the label
#
# Author: P. Provost
#
# Module History
#  00  10/07/2004  Initial release 

DEVICEFILE=$1
LABELFILE=$2
LOGFILE=$3
DOSLETTER=$4

echo "-> usbmemlabel.sh" >> $LOGFILE
echo "Getting the label from the usb flash memory drive at $DEVICEFILE for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> usbmemlabel.sh"
actzTrace "XMDA   F: usbmemlabel.sh: Getting the label from the usb flash memory drive at $DEVICEFILE for `date`"

# If the usb flash memory drive is DOS formatted, retrieve the volume label using mdir
if mdir $DOSLETTER > $LABELFILE 2>&1; then
    actzTrace "XMDA   F: usbmemlabel.sh: Successfully retrieved the volume label using mdir."
    actzTrace "XMDA   F: usbmemlabel.sh: Label File Listing:"
    echo "Successfully retrieved the volume label using mdir." >> $LOGFILE
    echo "Label File Listing:" >> $LOGFILE
    cat $LABELFILE >> $LOGFILE
    
# Else if the usb flash memory drive is Linux formatted, retrieve the volume label using e2label     
elif /sbin/e2label $DEVICEFILE > $LABELFILE 2>&1; then
    actzTrace "XMDA   F: usbmemlabel.sh: Successfully retrieved the volume label using e2label."
    actzTrace "XMDA   F: usbmemlabel.sh: Label File Listing:"
    echo "Successfully retrieved the volume label using e2label." >> $LOGFILE
    echo "Label File Listing:" >> $LOGFILE
    cat $LABELFILE >> $LOGFILE
    
# Else the script failed to retrieve the volume label from the usb flash memory drive         
else
    actzTrace "XMDA   F: usbmemlabel.sh: The attempts to retrieve the label from the usb flash memory drive have failed."
    echo "The attempts to retrieve the label from the usb flash memory drive have failed." >> $LOGFILE
    exit 1
fi

actzTrace "XMDA   T: <- usbmemlabel.sh"

echo "<- usbmemlabel.sh" >> $LOGFILE
echo "" >> $LOGFILE

exit 0

